<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/* 

    This is the "Auth AJAX"

*/
class Authenticate extends CI_Controller {

    protected $browserResponse;
    
	public function __construct(){

        parent::__construct();
		$this->browserResponse = array('status'=>'error','message'=>'Something went wrong! Please try again','redirect'=>'');
    
    }

	private function checkValidAJAX(){
		if( !$this->input->is_ajax_request() )
			die('Unauthorize Access!!');
	}

    /* Verify User Login */
    public function verifyLogin(){

		$this->checkValidAJAX();
        
        $data['u_email']    = $this->input->post('ppl_email'); 
        $data['u_password'] = $this->input->post('ppl_pass'); 
        $remember_me = isset($_POST['ppl_rememberme'])? 1 : 0 ; 

        $res = $this->Qdb->select_data('u_id,u_name,u_password,u_email,u_pic,u_status,u_type,u_plan', 'usertbl', array('u_email' => $data['u_email'] ));

        if( !empty($res) ){
            $user_data = $res[0];
            
            if($user_data['u_password'] != md5($data['u_password'])){
				$this->browserResponse['message'] = 'Invalid credentials';
				echo json_encode($this->browserResponse);die();
			}
			if($user_data['u_status'] == 2 ){
				$this->browserResponse['message'] = 'Your account is InActive. Please, contact support.';
				echo json_encode($this->browserResponse);die(); // InActive User
			}
			if($user_data['u_status'] == 3 ){
				$this->browserResponse['message'] = 'Your account is Blocked. Please, contact support.';
				echo json_encode($this->browserResponse);die();// Blocked User
			}
            if($user_data['u_type'] != 1){
                checkPlanDetails( $user_data['u_id'] );
            }


            // if passed above stages create session
            $session_data = array( 
                'username'  => $user_data['u_name'], 
                'email'     => $user_data['u_email'], 
                'u_type'    => $user_data['u_type'], 
                'plan_data' => $user_data['u_plan'], 
                'user_id'   => $user_data['u_id'], 
                'profile_pic'   => !empty($user_data['u_pic']) ? base_url() . $user_data['u_pic']: base_url() . DEFAULT_PIC, 
                'logged_in' => TRUE,
            );  
            $this->session->set_userdata($session_data);
            
            // set unset userdata cookie
            $cookie = array('u_email' => '', 'u_password' => '');
            if( $remember_me == 1 ){
                $cookie['u_email']    = $data['u_email'];
                $cookie['u_password'] = $data['u_password'];
            }

            set_cookie('u_em', $cookie['u_email'], time()+86400); 
            set_cookie('u_ps', $cookie['u_password'], time()+86400); 

            $this->browserResponse['status'] = 'success';
            $this->browserResponse['message'] = 'Welcome, you logged in successfully.';
            $this->browserResponse['redirect'] = $user_data['u_type'] == 1 ? '/admin' : ($user_data['u_type'] == 7 ? '/designer' : '/');
        }else{
            $this->browserResponse['message'] = 'Invalid credentials';
        }

        echo json_encode($this->browserResponse);

	
    }

    /* Verify and Sign Up User */
    public function verifySignUp(){

		$this->checkValidAJAX();

        $this->form_validation->set_rules(
            'pps_email', 'email',
            'required|is_unique[usertbl.u_email]',
            array(
                    'required'      => 'You have not provided %s.',
                    'is_unique'     => 'This %s already exists.'
            )
        );

        if ($this->form_validation->run() == FALSE){
            $this->browserResponse['message'] = strip_tags(validation_errors()) ;
        }
        else{

            $data['u_name'] = $this->input->post('pps_name'); 
            $data['u_email'] = $this->input->post('pps_email'); 
            $data['u_password'] = md5($this->input->post('pps_password')); 
            $data['u_type'] = 2; 
            $data['u_status'] = 1; 
            $data['u_purchaseddate'] = date('Y-m-d H:i:s'); 

            $res = $this->Qdb->insert_data('usertbl', $data);

            if( !empty($res) ){
                $this->browserResponse['status'] = 'success';
                $this->browserResponse['message'] = 'Congratulations, Your account has been successfully created';
                $this->browserResponse['redirect'] = '/login';
            }

        }

        echo json_encode($this->browserResponse);
	
    }
    
    /* Recover User's Password */
    public function recoverYourPassword(){
		$this->checkValidAJAX();		
		$res = $this->Qdb->select_data( 'u_id,u_name,u_password,u_type,u_status' , 'usertbl' , array('u_email'=> $this->input->post('ppf_email')));
		if(!empty($res)){
            $user_data = $res[0];
			if($user_data['u_status'] == 2 ){
				$this->browserResponse['message'] = 'Your account is InActive. Please, contact support.';
				echo json_encode($this->browserResponse);die(); // InActive User
			}
			if($user_data['u_status'] == 3 ){
				$this->browserResponse['message'] = 'Your account is Blocked. Please, contact support.';
				echo json_encode($this->browserResponse);die();// Blocked User
			}
			$pwd = substr(md5($user_data['u_password']),0,8);
			$this->Qdb->update_data( 'usertbl', array('u_password'=>md5($pwd)) , array('u_id'=>$user_data['u_id']) );
			
			$body  = '<p>Hello '.$user_data['u_name'].'</p>';
			$body .= '<p>Here is the new password for your '.$_SESSION['site_name'].' account.</p>';
			$body .= '<p>Password is : '.$pwd.'</p><br/>';
			$body .= '<p>To your success.<br/>Team, '.$_SESSION['site_name'].'</p>';
            sendEmailToUser($_POST['ppf_email'],'New Password ['.$_SESSION['site_name'].']',$body);
			// sendUserEmailMandrill($_POST['ppf_email'],'New Password ['.$_SESSION['site_name'].']',$body , $_SESSION['site_name']);
			
			$this->browserResponse['message'] = 'Check your email for the new password.';
			$this->browserResponse['status'] = 'success';
			$this->browserResponse['redirect'] = '/login';
		}
		else
			$this->browserResponse['message'] = 'We can\'t find your email.';

		echo json_encode($this->browserResponse);die();
	}

}
